<?php

/*
 * tnef_file_rtf.php
 *
 *  Bernd Wiegmann <bernd@wib-software.de>
 *  (c) 2003 (GNU GPL - see ../../COPYING)
 *
 */

/*
 *   $Header: /storage/repository/attachment_tnef/tnef_file_rtf.php,v 1.2 2003/10/08 15:55:46 bernd Exp $
 *
 *   $Log: tnef_file_rtf.php,v $
 *   Revision 1.2  2003/10/08 15:55:46  bernd
 *   Added .rtf for RTF Filename.
 *
 *   Revision 1.1  2003/10/06 16:21:55  bernd
 *   Preparations for 0.6
 *
 *
 */

include_once(VIS_PATH_PLUGINS.'attachment_tnef/tnef_file_base.php');

define("CRTF_UNCOMPRESSED",          0x414c454d);
define("CRTF_COMPRESSED",            0x75465a4c);

class TnefFileRTF extends TnefFileBase {
  var $size;

  function TnefFileRTF($tnef_debug, $buffer) {
    $this->TnefFileBase($tnef_debug);
    $this->type = "application/rtf";
    $this->name = "EmbeddedRTF.rtf";

    $this->decode_crtf($buffer);
  }

  function getSize() {
    return $this->size;
  }

  function decode_crtf(&$buffer) {
    $size_compressed = tnef_geti32($buffer);
    $this->size = tnef_geti32($buffer);
    $magic = tnef_geti32($buffer);
    $crc32 = tnef_geti32($buffer);

    if ($this->tnef_debug) {
      tnef_log("CRTF: size comp=$size_compressed, size=$this->size");
    }

    switch ($magic) {
    case CRTF_COMPRESSED:
      $this->uncompress_rtf($buffer);
      break;

    case CRTF_UNCOMPRESSED:
      $this->content = $buffer;
      break;

    default:
      if ($this->tnef_debug) {
	tnef_log("Unknown Compressed RTF Format");
      }
      break;
    }
  }

  function uncompress_rtf(&$buffer) {
    $uncomp = array();
    $in = 0;
    $out = 0;
    $flags = 0;
    $flag_count = 0;

    $preload = "{\\rtf1\ansi\mac\deff0\deftab720{\fonttbl;}{\f0\fnil \froman \fswiss \fmodern \fscript \fdecor MS Sans SerifSymbolArialTimes New RomanCourier{\colortbl\\red0\green0\blue0\n\r\par \pard\plain\f0\fs20\b\i\u\\tab\\tx";
    $length_preload = strlen($preload);
    for ($cnt = 0; $cnt < $length_preload; $cnt++) {
      $uncomp[$out++] = $preload{$cnt};
    }
    while ($out < ($this->size + $length_preload)) {
      if (($flag_count++ % 8) == 0) {
	$flags = ord($buffer{$in++});
      } else {
	$flags = $flags >> 1;
      }
      if (($flags & 1) != 0) {
	$offset = ord($buffer{$in++});
	$length = ord($buffer{$in++});
	$offset = ($offset << 4) | ($length >> 4);
	$length = ($length & 0xF) + 2;
	$offset = ((int)($out / 4096)) * 4096 + $offset;
	if ($offset >= $out) {
	  $offset -= 4096;
	}
	$end = $offset + $length;
	while ($offset < $end) {
	  $uncomp[$out++] = $uncomp[$offset++];
	}
      } else {
	$uncomp[$out++] = $buffer{$in++};
      }
    }
    $this->content = substr_replace(implode("", $uncomp), "", 0, $length_preload);
    $length=strlen($this->content);
    tnef_log("real=$length, est=$this->size out=$out");
  }

}

?>